@extends('layouts.admin')

@section('title', 'Roles Management')

@section('content')
<div class="roles-management">
    <div class="dashboard-header">
        <h1>Role Management</h1>
        <p>Create and manage user roles and their permissions</p>
    </div>

    <div class="users-header">
        <div class="title">
            <h2>Roles</h2>
        </div>
        <div class="users-actions">
            <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create New Role
            </a>
        </div>
    </div>

    <div class="roles-grid">
        @foreach($roles as $role)
            <div class="role-card">
                <div class="role-header">
                    <h3>
                        <span class="role-badge" style="background-color: {{ $role->color ?? '#4B8BFF' }}"></span>
                        {{ $role->name }}
                    </h3>
                    <div class="role-actions">
                        <a href="{{ route('admin.roles.edit', $role) }}" class="btn-icon btn-primary" title="Edit Role">
                            <i class="fas fa-edit"></i>
                        </a>
                        @if(!in_array($role->name, ['super-admin', 'admin']))
                            <form action="{{ route('admin.roles.destroy', $role) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn-icon btn-danger" 
                                        onclick="return confirm('Are you sure you want to delete this role?')"
                                        title="Delete Role">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
                <div class="role-body">
                    <div class="role-description">
                        <p>Permissions assigned to this role:</p>
                    </div>
                    <div class="permissions-container">
                        @if($role->permissions->count() > 0)
                            <div class="permissions-list">
                                @foreach($role->permissions as $permission)
                                    <div class="permission-item">
                                        <i class="fas fa-check-circle"></i>
                                        <span>{{ $permission->name }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="no-permissions">
                                <i class="fas fa-exclamation-circle"></i>
                                <p>No permissions assigned to this role.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection